 aR  w Q mP9      h	 oP       nSystem-wide$SYMBOLSPACE (24)
$COMPACT
$NOLIST

MODULE ScribblePas;

{ $INCLUDE (``Incs_Pas`Con_Pas~Inc~) }

$INCLUDE (``Incs_Pas`Common~Inc~)
$INCLUDE (``Incs_Pas`OS_P~Inc~)
$INCLUDE (``Incs_Pas`OS_T~Inc~)
$INCLUDE (``Incs_Pas`String_T~Inc~)
$INCLUDE (``Incs_Pas`String_P~Inc~)
$INCLUDE (``Incs_Pas`Window_T~Inc~)
$INCLUDE (``Incs_Pas`Window_P~Inc~)

$INCLUDE (``Incs_Pad`Controls~Inc~)
$INCLUDE (``Incs_Pad`Events~Inc~)
$INCLUDE (``Incs_Pad`Graphics~Inc~)
$INCLUDE (``Incs_Pad`Overlay~Inc~)
$INCLUDE (``Incs_Pad`Utility~Inc~)
$INCLUDE (``Incs_Pad`Windows~Inc~)

{ $INCLUDE (``Incs_Pad`Recogniz~Inc~) }

PUBLIC ScribblePas;
  PROCEDURE ScribblePad
    (windowID: Word; VAR spRect: Rectangle; VAR error: Word);


{--------------------------------------------------------}
{                         Locals                         }
{--------------------------------------------------------}

PRIVATE ScribblePas;
CONST
  insetAmt       = 2;
  buttonFudge    = 4;  { The white space around text in the button }
  buttonInsetAmt = 8;  { Distance between buttons or button and frame }
  paletteWidth   = 18; { Width of a cursor + 1 pixel inversion frame }
  paletteHeight  = 18; { Height of a cursor + 1 pixel inversion frame }

  okayCtrlID     = 0;
  cancelCtrlID   = 1;

TYPE
  DrawChoiceType   = (nullChoice, penChoice, eraserChoice,
                      lineChoice, rectChoice, rndRectChoice, circleChoice);
  PaletteRectsType = ARRAY [penChoice..circleChoice] OF Rectangle;

VAR
  currentCursor:  Word;
  curDrawCursor:  Word;

  okayControl:    ControlRecd;
  cancelControl:  ControlRecd;

  curDrawChoice:  DrawChoiceType;
  lastDrawChoice: DrawChoiceType;

  paletteRects:   PaletteRectsType;

  scribbleRect:   Rectangle;
  paletteRect:    Rectangle;
  drawAreaRect:   Rectangle;
$EJ

{--------------------------------------------------------}
{                 InitializeScribblePad                  }
{--------------------------------------------------------}

PROCEDURE InitializeScribblePad (windowID: Word; VAR spRect: Rectangle);
VAR
  scribbleRight:  Integer;
  scribbleBottom: Integer;
  bottomMargin:   Integer;
  buttonHeight:   Integer;
  buttonWidth:    Integer;
  controlTop:     Integer;
  okayLeft:       Integer;
  cancelLeft:     Integer;
  index:          DrawChoiceType;
  r:              Rectangle;

BEGIN
scribbleRect.topLeft.x := spRect.topLeft.x;
scribbleRect.topLeft.y := spRect.topLeft.y;
scribbleRect.extent.x  := spRect.extent.x;
scribbleRect.extent.y  := spRect.extent.y;

scribbleRight  := scribbleRect.topLeft.x + scribbleRect.extent.x - 1;
scribbleBottom := scribbleRect.topLeft.y + scribbleRect.extent.y - 1;
bottomMargin   := (CharHeight * 2) + insetAmt;

buttonHeight := CharHeight + buttonFudge;
buttonWidth  := CharWidth * 8;
controlTop   := scribbleBottom - ((bottomMargin DIV 2) + (buttonHeight DIV 2));
okayLeft     := scribbleRight - (buttonWidth + buttonInsetAmt);
cancelLeft   := okayLeft - (buttonWidth + buttonInsetAmt);

r.topLeft.x   := okayLeft;
r.topLeft.y   := controlTop;
r.extent.x    := buttonWidth;
r.extent.y    := buttonHeight;
CtlInitControl (okayControl, okayCtrlID, buttonCtrl,
                0, 0, 0, 0, r, NewStringLit ('OK'));

r.topLeft.x   := cancelLeft;
{ These values were just set above -
r.topLeft.y   := controlTop;
r.extent.x    := buttonWidth;
r.extent.y    := buttonHeight;
}
CtlInitControl (cancelControl, cancelCtrlID, buttonCtrl,
                0, 0, 0, 0, r, NewStringLit ('Cancel'));

{ ZZZZ- This doesn't produce very efficient code (vs MoveBytes) }

drawAreaRect := scribbleRect;
WinInsetRectangle (drawAreaRect, insetAmt+1);
drawAreaRect.extent.y := drawAreaRect.extent.y - bottomMargin + insetAmt+1;
drawAreaRect.extent.x := drawAreaRect.extent.x - (paletteWidth+1); {For frame}
WinOffsetRectangle (drawAreaRect, paletteWidth+1, 0);

paletteRect := drawAreaRect;
paletteRect.extent.x := paletteWidth;
WinOffsetRectangle (paletteRect, -(paletteWidth+1), 0);

r := paletteRect;
r.extent.x := paletteWidth;
r.extent.y := paletteHeight;

curDrawChoice := penChoice;
lastDrawChoice := circleChoice;

FOR index := penChoice TO lastDrawChoice DO
  BEGIN
  paletteRects[index] := r;
  WinOffsetRectangle (r, 0, paletteWidth+1);
  END;

DrawScribblePad;

currentCursor := ptrCursor;
curDrawCursor := penCursor;
END;
$EJ

{--------------------------------------------------------}
{                    DrawScribblePad                     }
{--------------------------------------------------------}

PROCEDURE DrawScribblePad;
VAR
  x:     Integer;
  y:     Integer;
  index: DrawChoiceType;
  r:     Rectangle;

BEGIN
WinEraseRectangle (scribbleRect);
WinDrawRectFrame (scribbleRect);
DrawAroundRect (paletteRect);
DrawAroundRect (drawAreaRect);
FOR index := penChoice TO lastDrawChoice DO
  BEGIN
  { ZZZZ- A CopyRect call would be more efficient }
  r := paletteRects[index];
  { Draw image }
  CASE index OF
    {BEGIN}
    penChoice:
      BEGIN
      x := r.topLeft.x + 1;
      y := r.topLeft.y + 1;
      { This mess draws a pen image - yeech!! }
      WinDrawLine (x+9, y+4, x+12,y+1);
      WinDrawLine (x+2, y+12,x+13,y+1);
      WinDrawLine (x+1, y+14,x+14,y+1);
      WinDrawLine (x+3, y+13,x+14,y+2);
      WinDrawLine (x+11,y+6, x+14,y+3);
      WinDrawLine (x+9, y+9, x+12,y+6);
      END;
    eraserChoice:
      BEGIN
      x := r.topLeft.x + 1;
      y := r.topLeft.y + 1;
      { This mess draws a chalkboard eraser image - yeech!! }
      WinDrawLine (x+8, y+2, x+1, y+9);
      WinDrawLine (x+8, y+2, x+14,y+2);
      WinDrawLine (x+14,y+2, x+7, y+9);
      WinDrawLine (x+14,y+2, x+14,y+6);
      WinDrawLine (x+14,y+5, x+7, y+12);
      WinDrawLine (x+14,y+6, x+7, y+13);
      WinDrawLine (x+1, y+9, x+7, y+9);
      WinDrawLine (x+1, y+9, x+1, y+12);
      WinDrawLine (x+1, y+12,x+7, y+12);
      WinDrawLine (x+7, y+9, x+7, y+13);
      WinDrawLine (x+7, y+13,x+2, y+13);
      END;
    lineChoice:
      BEGIN
      WinInsetRectangle (r, 4);
      WinDrawLine (r.topLeft.x + r.extent.x-1, r.topLeft.y,
                   r.topLeft.x, r.topLeft.y + r.extent.y-1);
      WinInsetRectangle (r, -4);
      END;
    rectChoice, rndRectChoice:
      BEGIN
      WinInsetRectangle (r, 3);
      r.topLeft.y := r.topLeft.y + 1;
      r.extent.y := r.extent.y - 2;
      IF index = rectChoice THEN
        WinDrawRectFrame (r)
      ELSE
        WinInvertRoundedRectFrame (r, 8);
      r.topLeft.y := r.topLeft.y - 1;
      r.extent.y := r.extent.y + 2;
      WinInsetRectangle (r, -3);
      END;
    circleChoice:
      BEGIN
      WinInvertCircleFrame (r.topLeft.x+4, r.topLeft.y+4, r.extent.x-8);
      END;
    OTHERWISE;
    END;
  DrawAroundRect (r);
  END;
InvertInsetRect (paletteRects[curDrawChoice]);
CtlDrawControl (cancelControl);
CtlDrawControl (okayControl);
END;
$EJ

{--------------------------------------------------------}
{                    DrawAroundRect                      }
{--------------------------------------------------------}

PROCEDURE DrawAroundRect (VAR r: Rectangle);
BEGIN
WinInsetRectangle (r, -1);
WinDrawRectFrame (r);
WinInsetRectangle (r, 1);
END;


{--------------------------------------------------------}
{                    InvertInsetRect                     }
{--------------------------------------------------------}

PROCEDURE InvertInsetRect (VAR r: Rectangle);
BEGIN
WinInsetRectangle (r, 1);
TurnCursorOff;
WinInvertRectangle (r);
TurnCursorOn;
WinInsetRectangle (r, -1);
END;
$EJ

{--------------------------------------------------------}
{                 CheckForCursorChange                   }
{--------------------------------------------------------}

PROCEDURE CheckForCursorChange (event: EventType);
VAR
  newCursor: Word;

BEGIN
newCursor := currentCursor;
IF PtInRect (event.screenX, event.screenY, drawAreaRect) THEN
  BEGIN
  IF currentCursor <> curDrawCursor THEN
    newCursor := curDrawCursor;
  END
ELSE IF currentCursor = curDrawCursor THEN
  newCursor := ptrCursor;
IF newCursor <> currentCursor THEN
  BEGIN
  currentCursor := newCursor;
  TurnCursorOff;
  SetCursorType (currentCursor);
  TurnCursorOn;
  END;
END;
$EJ

{--------------------------------------------------------}
{                         IMin                           }
{--------------------------------------------------------}

FUNCTION  IMin (value1, value2: Integer): Integer;
BEGIN
IF value1 < value2 THEN
  IMin := value1
ELSE
  IMin := value2;
END;

{--------------------------------------------------------}
{                   SetRectFromTwoPts                    }
{--------------------------------------------------------}

PROCEDURE SetRectFromTwoPts (x1, y1, x2, y2: Integer; VAR r: Rectangle);
BEGIN
r.topLeft.x := IMin (x1, x2);
r.topLeft.y := IMin (y1, y2);
r.extent.x  := Abs (x2 - x1) + 1;
r.extent.y  := Abs (y2 - y1) + 1;
END;
$EJ

{--------------------------------------------------------}
{                    DrawAnchoredItem                    }
{--------------------------------------------------------}

PROCEDURE DrawAnchoredItem (anchorX, anchorY, x, y: Integer; invertIt: Boolean);
VAR
  r: Rectangle;

BEGIN
IF curDrawChoice = lineChoice THEN
  BEGIN
  IF invertIt THEN
    WinInvertLine (anchorX, anchorY, x, y)
  ELSE
    WinDrawLine (anchorX, anchorY, x, y);
  END
ELSE { Only other anchored choices are rect, rndRect & circle choices }
  BEGIN
  SetRectFromTwoPts (anchorX, anchorY, x, y, r);
  IF curDrawChoice = rectChoice THEN
    BEGIN
    IF invertIt THEN
      WinInvertRectFrame (r)
    ELSE
      WinDrawRectFrame (r);
    END
  ELSE IF curDrawChoice = rndRectChoice THEN
    BEGIN
    IF invertIt THEN
      WinInvertRoundedRectFrame (r, IMin(IMin(r.extent.x, r.extent.y), 18));
    END
  ELSE
    BEGIN
    IF invertIt THEN
      WinInvertCircleFrame (r.topLeft.x, r.topLeft.y, r.extent.x);
    END;
  END;
END;
$EJ

{--------------------------------------------------------}
{                HandleCurrentDrawingTask                }
{--------------------------------------------------------}

PROCEDURE HandleCurrentDrawingTask (screenX, screenY: Integer);
VAR
  penDown:          Boolean;
  firstTime:        Boolean;
  anchoredChoice:   Boolean;
  ptInDrawArea:     Boolean;
  lastPtInDrawArea: Boolean;
  error:            Word;
  lastScreenX:      Integer;
  lastScreenY:      Integer;
  anchorX:          Integer;
  anchorY:          Integer;
  r:                Rectangle;

BEGIN
penDown := TRUE;
lastPtInDrawArea := TRUE;
lastScreenX := screenX;
lastScreenY := screenY;
anchoredChoice :=
 (curDrawChoice = lineChoice) OR (curDrawChoice = rectChoice) OR
 (curDrawChoice = rndRectChoice) OR (curDrawChoice = circleChoice);
IF anchoredChoice THEN  
  BEGIN
  anchorX := screenX;
  anchorY := screenY;
  END;
firstTime := TRUE;
REPEAT
  BEGIN
  ptInDrawArea := PtInRect (screenX, screenY, drawAreaRect);
  IF ptInDrawArea OR lastPtInDrawArea OR anchoredChoice THEN
    BEGIN
    TurnCursorOff;
    WinSetClip (drawAreaRect);
    IF curDrawChoice = penChoice THEN
      WinDrawLine (lastScreenX, lastScreenY, screenX, screenY)
    ELSE IF curDrawChoice = eraserChoice THEN
      BEGIN
      r.topLeft.x := screenX - 4;
      r.topLeft.y := screenY - 4;
      r.extent.x  := 9;
      r.extent.y  := 9;
      WinEraseRectangle (r);
      END
    ELSE { Only anchored choices remain }
      BEGIN
      IF NOT firstTime THEN
        DrawAnchoredItem (anchorX, anchorY, lastScreenX, lastScreenY, TRUE);
      DrawAnchoredItem (anchorX, anchorY, screenX, screenY, TRUE);
      END;
    WinResetClip;
    TurnCursorOn;
    END;
  lastScreenX := screenX;
  lastScreenY := screenY;
  lastPtInDrawArea := ptInDrawArea;
  REPEAT
    GetPt (screenX, screenY, penDown, error);
  UNTIL (NOT penDown) OR (error <> 0) OR
        (screenX <> lastScreenX) OR (screenY <> lastScreenY);
  firstTime := FALSE;
  END;
UNTIL (NOT penDown) OR (error <> 0);
IF anchoredChoice THEN
  BEGIN
  TurnCursorOff;
  WinSetClip (drawAreaRect);
  DrawAnchoredItem (anchorX, anchorY, lastScreenX, lastScreenY, FALSE);
  WinResetClip;
  TurnCursorOn;
  END;
END;
$EJ

{--------------------------------------------------------}
{              CheckPenInPaletteOrDrawArea               }
{--------------------------------------------------------}

PROCEDURE CheckForPenInPaletteOrDrawArea (event: EventType);
VAR
  penDown: Boolean;
  screenX: Integer;
  screenY: Integer;
  index:   DrawChoiceType;

BEGIN
CheckForCursorChange (event);
screenX := event.screenX;
screenY := event.screenY;
IF PtInRect (screenX, screenY, paletteRect) THEN
  BEGIN
  FOR index := penChoice TO lastDrawChoice DO
    BEGIN
    IF PtInRect (screenX, screenY, paletteRects[index]) THEN
      BEGIN
      IF index <> curDrawChoice THEN
        BEGIN
        InvertInsetRect (paletteRects[curDrawChoice]);
        curDrawChoice := index;
        InvertInsetRect (paletteRects[curDrawChoice]);
        IF curDrawChoice = penChoice THEN
          curDrawCursor := penCursor
        ELSE IF curDrawChoice = eraserChoice THEN
          curDrawCursor := boxCursor
        ELSE { curDrawChoice = line or rect or rndRect or circle choice }
          curDrawCursor := crsCursor;
        END
      ELSE { Double pen down will always follow after single pen down }
        BEGIN
        IF BitAnd (event.data1, doublePenDownMask) = doublePenDown THEN
          BEGIN
          IF index = eraserChoice THEN
            BEGIN
            TurnCursorOff;
            WinEraseRectangle (drawAreaRect);
            TurnCursorOn;
            END;
          END;
        END;
      END;
    END;
  END
ELSE IF PtInRect (screenX, screenY, drawAreaRect) THEN
  BEGIN
  HandleCurrentDrawingTask (screenX, screenY);
  END;
END;
$EJ

{--------------------------------------------------------}
{                      ScribblePad                       }
{--------------------------------------------------------}


PROCEDURE ScribblePad (windowID: Word; VAR spRect: Rectangle; VAR error: Word);
VAR
  timeToExit:     Boolean;
  event:          EventType;

BEGIN
timeToExit := FALSE;
InitializeScribblePad (windowID, spRect);
REPEAT
  GetEvent (event, error);
  IF error = 0 THEN
    BEGIN
{
    IF NOT MenuHandleEvent (event) THEN
    IF NOT FieldHandleEvent (event) THEN
    IF NOT DialogHandleEvent (event) THEN
}
      BEGIN { Application specific actions handled here }
      IF (event.eType = penDownEvent) THEN
        BEGIN
        IF PtInRect (event.screenX, event.screenY, okayControl.rect) THEN
          BEGIN
          IF CtlControlPressed
            (okayControl, event.screenX, event.screenY) THEN
            timeToExit := TRUE
          END
        ELSE IF PtInRect (event.screenX, event.screenY, cancelControl.rect) THEN
          BEGIN
          IF CtlControlPressed
            (cancelControl, event.screenX, event.screenY) THEN
            timeToExit := TRUE
          END
        ELSE
          CheckForPenInPaletteOrDrawArea (event);
        END
      ELSE IF (event.eType = nullEvent) OR (event.eType = penUpEvent) THEN
        BEGIN
        CheckForCursorChange (event);
        END
      ELSE IF (event.eType = keyUpEvent) THEN
        BEGIN
        timeToExit := TRUE;
        END;
      END;
    END;
  UNTIL timeToExit;
END;
.
